package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{TagValue, TagKey, GroupArn}
import scala.jdk.CollectionConverters._
final case class TagResponse(
    arn: Option[GroupArn] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.TagResponse = {
    import TagResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.TagResponse
      .builder()
      .optionallyWith(
        arn.map(value => GroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.TagResponse.ReadOnly =
    zio.aws.resourcegroups.model.TagResponse.wrap(buildAwsValue())
}
object TagResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.TagResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.TagResponse =
      zio.aws.resourcegroups.model
        .TagResponse(arn.map(value => value), tags.map(value => value))
    def arn: Option[GroupArn]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, GroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.TagResponse
  ) extends zio.aws.resourcegroups.model.TagResponse.ReadOnly {
    override val arn: Option[GroupArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupArn(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.resourcegroups.model.primitives.TagKey(
              key
            ) -> zio.aws.resourcegroups.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.TagResponse
  ): zio.aws.resourcegroups.model.TagResponse.ReadOnly = new Wrapper(impl)
}
