package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{
  ErrorCode,
  ErrorMessage,
  ResourceArn
}
import scala.jdk.CollectionConverters._
final case class FailedResource(
    resourceArn: Option[ResourceArn] = None,
    errorMessage: Option[ErrorMessage] = None,
    errorCode: Option[ErrorCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.FailedResource = {
    import FailedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.FailedResource
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.FailedResource.ReadOnly =
    zio.aws.resourcegroups.model.FailedResource.wrap(buildAwsValue())
}
object FailedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.FailedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.FailedResource =
      zio.aws.resourcegroups.model.FailedResource(
        resourceArn.map(value => value),
        errorMessage.map(value => value),
        errorCode.map(value => value)
      )
    def resourceArn: Option[ResourceArn]
    def errorMessage: Option[ErrorMessage]
    def errorCode: Option[ErrorCode]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.FailedResource
  ) extends zio.aws.resourcegroups.model.FailedResource.ReadOnly {
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.resourcegroups.model.primitives.ResourceArn(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.resourcegroups.model.primitives.ErrorMessage(value))
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.resourcegroups.model.primitives.ErrorCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.FailedResource
  ): zio.aws.resourcegroups.model.FailedResource.ReadOnly = new Wrapper(impl)
}
