package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateGroupResponse(
    group: Option[zio.aws.resourcegroups.model.Group] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.UpdateGroupResponse = {
    import UpdateGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.UpdateGroupResponse
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.UpdateGroupResponse.ReadOnly =
    zio.aws.resourcegroups.model.UpdateGroupResponse.wrap(buildAwsValue())
}
object UpdateGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.UpdateGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.UpdateGroupResponse =
      zio.aws.resourcegroups.model
        .UpdateGroupResponse(group.map(value => value.asEditable))
    def group: Option[zio.aws.resourcegroups.model.Group.ReadOnly]
    def getGroup
        : ZIO[Any, AwsError, zio.aws.resourcegroups.model.Group.ReadOnly] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateGroupResponse
  ) extends zio.aws.resourcegroups.model.UpdateGroupResponse.ReadOnly {
    override val group: Option[zio.aws.resourcegroups.model.Group.ReadOnly] =
      scala
        .Option(impl.group())
        .map(value => zio.aws.resourcegroups.model.Group.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateGroupResponse
  ): zio.aws.resourcegroups.model.UpdateGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
