package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class UngroupResourcesResponse(
    succeeded: Option[Iterable[ResourceArn]] = None,
    failed: Option[Iterable[zio.aws.resourcegroups.model.FailedResource]] =
      None,
    pending: Option[Iterable[zio.aws.resourcegroups.model.PendingResource]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.UngroupResourcesResponse = {
    import UngroupResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.UngroupResourcesResponse
      .builder()
      .optionallyWith(
        succeeded.map(value =>
          value.map { item =>
            ResourceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.succeeded)
      .optionallyWith(
        failed.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failed)
      .optionallyWith(
        pending.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pending)
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.UngroupResourcesResponse.ReadOnly =
    zio.aws.resourcegroups.model.UngroupResourcesResponse.wrap(buildAwsValue())
}
object UngroupResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.UngroupResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.UngroupResourcesResponse =
      zio.aws.resourcegroups.model.UngroupResourcesResponse(
        succeeded.map(value => value),
        failed.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pending.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def succeeded: Option[List[ResourceArn]]
    def failed
        : Option[List[zio.aws.resourcegroups.model.FailedResource.ReadOnly]]
    def pending
        : Option[List[zio.aws.resourcegroups.model.PendingResource.ReadOnly]]
    def getSucceeded: ZIO[Any, AwsError, List[ResourceArn]] =
      AwsError.unwrapOptionField("succeeded", succeeded)
    def getFailed: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.FailedResource.ReadOnly
    ]] = AwsError.unwrapOptionField("failed", failed)
    def getPending: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.PendingResource.ReadOnly
    ]] = AwsError.unwrapOptionField("pending", pending)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.UngroupResourcesResponse
  ) extends zio.aws.resourcegroups.model.UngroupResourcesResponse.ReadOnly {
    override val succeeded: Option[List[ResourceArn]] = scala
      .Option(impl.succeeded())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.primitives.ResourceArn(item)
        }.toList
      )
    override val failed
        : Option[List[zio.aws.resourcegroups.model.FailedResource.ReadOnly]] =
      scala
        .Option(impl.failed())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourcegroups.model.FailedResource.wrap(item)
          }.toList
        )
    override val pending
        : Option[List[zio.aws.resourcegroups.model.PendingResource.ReadOnly]] =
      scala
        .Option(impl.pending())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourcegroups.model.PendingResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.UngroupResourcesResponse
  ): zio.aws.resourcegroups.model.UngroupResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
