package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteGroupResponse(
    group: Option[zio.aws.resourcegroups.model.Group] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.DeleteGroupResponse = {
    import DeleteGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.DeleteGroupResponse
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.DeleteGroupResponse.ReadOnly =
    zio.aws.resourcegroups.model.DeleteGroupResponse.wrap(buildAwsValue())
}
object DeleteGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.DeleteGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.DeleteGroupResponse =
      zio.aws.resourcegroups.model
        .DeleteGroupResponse(group.map(value => value.asEditable))
    def group: Option[zio.aws.resourcegroups.model.Group.ReadOnly]
    def getGroup
        : ZIO[Any, AwsError, zio.aws.resourcegroups.model.Group.ReadOnly] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.DeleteGroupResponse
  ) extends zio.aws.resourcegroups.model.DeleteGroupResponse.ReadOnly {
    override val group: Option[zio.aws.resourcegroups.model.Group.ReadOnly] =
      scala
        .Option(impl.group())
        .map(value => zio.aws.resourcegroups.model.Group.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.DeleteGroupResponse
  ): zio.aws.resourcegroups.model.DeleteGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
