package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{TagKey, GroupArn}
import scala.jdk.CollectionConverters._
final case class UntagResponse(
    arn: Option[GroupArn] = None,
    keys: Option[Iterable[TagKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.UntagResponse = {
    import UntagResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.UntagResponse
      .builder()
      .optionallyWith(
        arn.map(value => GroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            TagKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keys)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.UntagResponse.ReadOnly =
    zio.aws.resourcegroups.model.UntagResponse.wrap(buildAwsValue())
}
object UntagResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.UntagResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.UntagResponse =
      zio.aws.resourcegroups.model
        .UntagResponse(arn.map(value => value), keys.map(value => value))
    def arn: Option[GroupArn]
    def keys: Option[List[TagKey]]
    def getArn: ZIO[Any, AwsError, GroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getKeys: ZIO[Any, AwsError, List[TagKey]] =
      AwsError.unwrapOptionField("keys", keys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.UntagResponse
  ) extends zio.aws.resourcegroups.model.UntagResponse.ReadOnly {
    override val arn: Option[GroupArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupArn(value))
    override val keys: Option[List[TagKey]] = scala
      .Option(impl.keys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.primitives.TagKey(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.UntagResponse
  ): zio.aws.resourcegroups.model.UntagResponse.ReadOnly = new Wrapper(impl)
}
