package zio.aws.resourcegroups.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{NextToken, MaxResults}
import scala.jdk.CollectionConverters._
final case class SearchResourcesRequest(
    resourceQuery: zio.aws.resourcegroups.model.ResourceQuery,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest = {
    import SearchResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest
      .builder()
      .resourceQuery(resourceQuery.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.SearchResourcesRequest.ReadOnly =
    zio.aws.resourcegroups.model.SearchResourcesRequest.wrap(buildAwsValue())
}
object SearchResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.SearchResourcesRequest =
      zio.aws.resourcegroups.model.SearchResourcesRequest(
        resourceQuery.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceQuery: zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getResourceQuery: ZIO[
      Any,
      Nothing,
      zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    ] = ZIO.succeed(resourceQuery)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest
  ) extends zio.aws.resourcegroups.model.SearchResourcesRequest.ReadOnly {
    override val resourceQuery
        : zio.aws.resourcegroups.model.ResourceQuery.ReadOnly =
      zio.aws.resourcegroups.model.ResourceQuery.wrap(impl.resourceQuery())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.resourcegroups.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.resourcegroups.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest
  ): zio.aws.resourcegroups.model.SearchResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
