package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class CreateGroupResponse(
    group: Option[zio.aws.resourcegroups.model.Group] = None,
    resourceQuery: Option[zio.aws.resourcegroups.model.ResourceQuery] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    groupConfiguration: Option[
      zio.aws.resourcegroups.model.GroupConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse = {
    import CreateGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .optionallyWith(resourceQuery.map(value => value.buildAwsValue()))(
        _.resourceQuery
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(groupConfiguration.map(value => value.buildAwsValue()))(
        _.groupConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly =
    zio.aws.resourcegroups.model.CreateGroupResponse.wrap(buildAwsValue())
}
object CreateGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.CreateGroupResponse =
      zio.aws.resourcegroups.model.CreateGroupResponse(
        group.map(value => value.asEditable),
        resourceQuery.map(value => value.asEditable),
        tags.map(value => value),
        groupConfiguration.map(value => value.asEditable)
      )
    def group: Option[zio.aws.resourcegroups.model.Group.ReadOnly]
    def resourceQuery
        : Option[zio.aws.resourcegroups.model.ResourceQuery.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def groupConfiguration
        : Option[zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly]
    def getGroup
        : ZIO[Any, AwsError, zio.aws.resourcegroups.model.Group.ReadOnly] =
      AwsError.unwrapOptionField("group", group)
    def getResourceQuery: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    ] = AwsError.unwrapOptionField("resourceQuery", resourceQuery)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getGroupConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("groupConfiguration", groupConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse
  ) extends zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly {
    override val group: Option[zio.aws.resourcegroups.model.Group.ReadOnly] =
      scala
        .Option(impl.group())
        .map(value => zio.aws.resourcegroups.model.Group.wrap(value))
    override val resourceQuery
        : Option[zio.aws.resourcegroups.model.ResourceQuery.ReadOnly] = scala
      .Option(impl.resourceQuery())
      .map(value => zio.aws.resourcegroups.model.ResourceQuery.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.resourcegroups.model.primitives.TagKey(
              key
            ) -> zio.aws.resourcegroups.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val groupConfiguration
        : Option[zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly] =
      scala
        .Option(impl.groupConfiguration())
        .map(value =>
          zio.aws.resourcegroups.model.GroupConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse
  ): zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
