package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{GroupString, GroupName}
import scala.jdk.CollectionConverters._
final case class UpdateGroupQueryRequest(
    groupName: Option[GroupName] = None,
    group: Option[GroupString] = None,
    resourceQuery: zio.aws.resourcegroups.model.ResourceQuery
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryRequest = {
    import UpdateGroupQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryRequest
      .builder()
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        group.map(value => GroupString.unwrap(value): java.lang.String)
      )(_.group)
      .resourceQuery(resourceQuery.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.UpdateGroupQueryRequest.ReadOnly =
    zio.aws.resourcegroups.model.UpdateGroupQueryRequest.wrap(buildAwsValue())
}
object UpdateGroupQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.UpdateGroupQueryRequest =
      zio.aws.resourcegroups.model.UpdateGroupQueryRequest(
        groupName.map(value => value),
        group.map(value => value),
        resourceQuery.asEditable
      )
    def groupName: Option[GroupName]
    def group: Option[GroupString]
    def resourceQuery: zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroup: ZIO[Any, AwsError, GroupString] =
      AwsError.unwrapOptionField("group", group)
    def getResourceQuery: ZIO[
      Any,
      Nothing,
      zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    ] = ZIO.succeed(resourceQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryRequest
  ) extends zio.aws.resourcegroups.model.UpdateGroupQueryRequest.ReadOnly {
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupName(value))
    override val group: Option[GroupString] = scala
      .Option(impl.group())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupString(value))
    override val resourceQuery
        : zio.aws.resourcegroups.model.ResourceQuery.ReadOnly =
      zio.aws.resourcegroups.model.ResourceQuery.wrap(impl.resourceQuery())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryRequest
  ): zio.aws.resourcegroups.model.UpdateGroupQueryRequest.ReadOnly =
    new Wrapper(impl)
}
