package zio.aws.resourcegroups.model
import scala.jdk.CollectionConverters._
sealed trait GroupConfigurationStatus {
  def unwrap: software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus
}
object GroupConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus
  ): zio.aws.resourcegroups.model.GroupConfigurationStatus = value match {
    case software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus.UPDATE_COMPLETE =>
      val r = UPDATE_COMPLETE
      r
    case software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.resourcegroups.model.GroupConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus =
      software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object UPDATING
      extends zio.aws.resourcegroups.model.GroupConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus =
      software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus.UPDATING
  }
  case object UPDATE_COMPLETE
      extends zio.aws.resourcegroups.model.GroupConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus =
      software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus.UPDATE_COMPLETE
  }
  case object UPDATE_FAILED
      extends zio.aws.resourcegroups.model.GroupConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus =
      software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationStatus.UPDATE_FAILED
  }
}
