package zio.aws.resourcegroups
import zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly
import zio.aws.resourcegroups.model.{
  SearchResourcesRequest,
  UpdateGroupQueryRequest,
  ListGroupResourcesRequest,
  GetGroupRequest,
  UpdateGroupRequest,
  DeleteGroupRequest,
  GetGroupQueryRequest,
  UntagRequest,
  TagRequest,
  ListGroupsRequest,
  PutGroupConfigurationRequest,
  GetGroupConfigurationRequest,
  GetTagsRequest,
  CreateGroupRequest,
  GroupResourcesRequest,
  UngroupResourcesRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.test.mock.{Proxy, Mock}
object ResourceGroupsMock extends Mock[ResourceGroups] {
  object GetGroupQuery
      extends Effect[
        GetGroupQueryRequest,
        AwsError,
        zio.aws.resourcegroups.model.GetGroupQueryResponse.ReadOnly
      ]
  object Untag
      extends Effect[
        UntagRequest,
        AwsError,
        zio.aws.resourcegroups.model.UntagResponse.ReadOnly
      ]
  object DeleteGroup
      extends Effect[
        DeleteGroupRequest,
        AwsError,
        zio.aws.resourcegroups.model.DeleteGroupResponse.ReadOnly
      ]
  object ListGroups
      extends Effect[ListGroupsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly,
        zio.aws.resourcegroups.model.Group.ReadOnly
      ]]
  object ListGroupsPaginated
      extends Effect[
        ListGroupsRequest,
        AwsError,
        zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly
      ]
  object UpdateGroupQuery
      extends Effect[
        UpdateGroupQueryRequest,
        AwsError,
        zio.aws.resourcegroups.model.UpdateGroupQueryResponse.ReadOnly
      ]
  object SearchResources
      extends Effect[SearchResourcesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly,
        ReadOnly
      ]]
  object SearchResourcesPaginated
      extends Effect[
        SearchResourcesRequest,
        AwsError,
        zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly
      ]
  object CreateGroup
      extends Effect[
        CreateGroupRequest,
        AwsError,
        zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly
      ]
  object Tag
      extends Effect[
        TagRequest,
        AwsError,
        zio.aws.resourcegroups.model.TagResponse.ReadOnly
      ]
  object UpdateGroup
      extends Effect[
        UpdateGroupRequest,
        AwsError,
        zio.aws.resourcegroups.model.UpdateGroupResponse.ReadOnly
      ]
  object GroupResources
      extends Effect[
        GroupResourcesRequest,
        AwsError,
        zio.aws.resourcegroups.model.GroupResourcesResponse.ReadOnly
      ]
  object GetGroup
      extends Effect[
        GetGroupRequest,
        AwsError,
        zio.aws.resourcegroups.model.GetGroupResponse.ReadOnly
      ]
  object ListGroupResources
      extends Effect[ListGroupResourcesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly,
        ReadOnly
      ]]
  object ListGroupResourcesPaginated
      extends Effect[
        ListGroupResourcesRequest,
        AwsError,
        zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly
      ]
  object GetGroupConfiguration
      extends Effect[
        GetGroupConfigurationRequest,
        AwsError,
        zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly
      ]
  object UngroupResources
      extends Effect[
        UngroupResourcesRequest,
        AwsError,
        zio.aws.resourcegroups.model.UngroupResourcesResponse.ReadOnly
      ]
  object PutGroupConfiguration
      extends Effect[
        PutGroupConfigurationRequest,
        AwsError,
        zio.aws.resourcegroups.model.PutGroupConfigurationResponse.ReadOnly
      ]
  object GetTags
      extends Effect[
        GetTagsRequest,
        AwsError,
        zio.aws.resourcegroups.model.GetTagsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ResourceGroups] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ResourceGroups {
          val api: ResourceGroupsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ResourceGroups = this
          def getGroupQuery(request: GetGroupQueryRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.GetGroupQueryResponse.ReadOnly
          ] = proxy(GetGroupQuery, request)
          def untag(
              request: UntagRequest
          ): IO[AwsError, zio.aws.resourcegroups.model.UntagResponse.ReadOnly] =
            proxy(Untag, request)
          def deleteGroup(request: DeleteGroupRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.DeleteGroupResponse.ReadOnly
          ] = proxy(DeleteGroup, request)
          def listGroups(
              request: ListGroupsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly,
            zio.aws.resourcegroups.model.Group.ReadOnly
          ]] = proxy(ListGroups, request)
          def listGroupsPaginated(request: ListGroupsRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly
          ] = proxy(ListGroupsPaginated, request)
          def updateGroupQuery(request: UpdateGroupQueryRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.UpdateGroupQueryResponse.ReadOnly
          ] = proxy(UpdateGroupQuery, request)
          def searchResources(
              request: SearchResourcesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly,
            ReadOnly
          ]] = proxy(SearchResources, request)
          def searchResourcesPaginated(request: SearchResourcesRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly
          ] = proxy(SearchResourcesPaginated, request)
          def createGroup(request: CreateGroupRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly
          ] = proxy(CreateGroup, request)
          def tag(
              request: TagRequest
          ): IO[AwsError, zio.aws.resourcegroups.model.TagResponse.ReadOnly] =
            proxy(Tag, request)
          def updateGroup(request: UpdateGroupRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.UpdateGroupResponse.ReadOnly
          ] = proxy(UpdateGroup, request)
          def groupResources(request: GroupResourcesRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.GroupResourcesResponse.ReadOnly
          ] = proxy(GroupResources, request)
          def getGroup(request: GetGroupRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.GetGroupResponse.ReadOnly
          ] = proxy(GetGroup, request)
          def listGroupResources(
              request: ListGroupResourcesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly,
            ReadOnly
          ]] = proxy(ListGroupResources, request)
          def listGroupResourcesPaginated(
              request: ListGroupResourcesRequest
          ): IO[
            AwsError,
            zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly
          ] = proxy(ListGroupResourcesPaginated, request)
          def getGroupConfiguration(request: GetGroupConfigurationRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly
          ] = proxy(GetGroupConfiguration, request)
          def ungroupResources(request: UngroupResourcesRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.UngroupResourcesResponse.ReadOnly
          ] = proxy(UngroupResources, request)
          def putGroupConfiguration(request: PutGroupConfigurationRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.PutGroupConfigurationResponse.ReadOnly
          ] = proxy(PutGroupConfiguration, request)
          def getTags(request: GetTagsRequest): IO[
            AwsError,
            zio.aws.resourcegroups.model.GetTagsResponse.ReadOnly
          ] = proxy(GetTags, request)
        }
      }
    }
    .toLayer
}
