package zio.aws.resourcegroups.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{
  NextToken,
  MaxResults,
  GroupString,
  GroupName
}
import scala.jdk.CollectionConverters._
final case class ListGroupResourcesRequest(
    groupName: Option[GroupName] = None,
    group: Option[GroupString] = None,
    filters: Option[Iterable[zio.aws.resourcegroups.model.ResourceFilter]] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest = {
    import ListGroupResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest
      .builder()
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        group.map(value => GroupString.unwrap(value): java.lang.String)
      )(_.group)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.ListGroupResourcesRequest.ReadOnly =
    zio.aws.resourcegroups.model.ListGroupResourcesRequest.wrap(buildAwsValue())
}
object ListGroupResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ListGroupResourcesRequest =
      zio.aws.resourcegroups.model.ListGroupResourcesRequest(
        groupName.map(value => value),
        group.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def groupName: Option[GroupName]
    def group: Option[GroupString]
    def filters
        : Option[List[zio.aws.resourcegroups.model.ResourceFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroup: ZIO[Any, AwsError, GroupString] =
      AwsError.unwrapOptionField("group", group)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.ResourceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest
  ) extends zio.aws.resourcegroups.model.ListGroupResourcesRequest.ReadOnly {
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupName(value))
    override val group: Option[GroupString] = scala
      .Option(impl.group())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupString(value))
    override val filters
        : Option[List[zio.aws.resourcegroups.model.ResourceFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourcegroups.model.ResourceFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.resourcegroups.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.resourcegroups.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest
  ): zio.aws.resourcegroups.model.ListGroupResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
