package zio.aws.resourceexplorer2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateIndexTypeResponse(
    arn: Optional[String] = Optional.Absent,
    lastUpdatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    state: Optional[zio.aws.resourceexplorer2.model.IndexState] =
      Optional.Absent,
    `type`: Optional[zio.aws.resourceexplorer2.model.IndexType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeResponse = {
    import UpdateIndexTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        lastUpdatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.lastUpdatedAt)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse
      .wrap(buildAwsValue())
}
object UpdateIndexTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse =
      zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse(
        arn.map(value => value),
        lastUpdatedAt.map(value => value),
        state.map(value => value),
        `type`.map(value => value)
      )
    def arn: Optional[String]
    def lastUpdatedAt: Optional[SyntheticTimestamp_date_time]
    def state: Optional[zio.aws.resourceexplorer2.model.IndexState]
    def `type`: Optional[zio.aws.resourceexplorer2.model.IndexType]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getLastUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getState
        : ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.IndexState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.IndexType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeResponse
  ) extends zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val lastUpdatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedAt())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val state: Optional[zio.aws.resourceexplorer2.model.IndexState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.resourceexplorer2.model.IndexState.wrap(value))
    override val `type`: Optional[zio.aws.resourceexplorer2.model.IndexType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.resourceexplorer2.model.IndexType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeResponse
  ): zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse.ReadOnly =
    new Wrapper(impl)
}
