package zio.aws.resourceexplorer2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.ListViewsInputMaxResultsInteger
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListViewsRequest(
    maxResults: Optional[ListViewsInputMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest = {
    import ListViewsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListViewsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.ListViewsRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.ListViewsRequest.wrap(buildAwsValue())
}
object ListViewsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.ListViewsRequest =
      zio.aws.resourceexplorer2.model.ListViewsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListViewsInputMaxResultsInteger]
    def nextToken: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, ListViewsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest
  ) extends zio.aws.resourceexplorer2.model.ListViewsRequest.ReadOnly {
    override val maxResults: Optional[ListViewsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .ListViewsInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest
  ): zio.aws.resourceexplorer2.model.ListViewsRequest.ReadOnly = new Wrapper(
    impl
  )
}
