package zio.aws.resourceexplorer2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.ListSupportedResourceTypesInputMaxResultsInteger
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSupportedResourceTypesRequest(
    maxResults: Optional[ListSupportedResourceTypesInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest = {
    import ListSupportedResourceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListSupportedResourceTypesInputMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.resourceexplorer2.model.ListSupportedResourceTypesRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.ListSupportedResourceTypesRequest
      .wrap(buildAwsValue())
}
object ListSupportedResourceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.resourceexplorer2.model.ListSupportedResourceTypesRequest =
      zio.aws.resourceexplorer2.model.ListSupportedResourceTypesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListSupportedResourceTypesInputMaxResultsInteger]
    def nextToken: Optional[String]
    def getMaxResults
        : ZIO[Any, AwsError, ListSupportedResourceTypesInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest
  ) extends zio.aws.resourceexplorer2.model.ListSupportedResourceTypesRequest.ReadOnly {
    override val maxResults
        : Optional[ListSupportedResourceTypesInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .ListSupportedResourceTypesInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest
  ): zio.aws.resourceexplorer2.model.ListSupportedResourceTypesRequest.ReadOnly =
    new Wrapper(impl)
}
