package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.resourceexplorer2.model.primitives.GetViewInputViewArnString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetViewRequest(viewArn: GetViewInputViewArnString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest = {
    import GetViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest
      .builder()
      .viewArn(GetViewInputViewArnString.unwrap(viewArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.GetViewRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.GetViewRequest.wrap(buildAwsValue())
}
object GetViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.GetViewRequest =
      zio.aws.resourceexplorer2.model.GetViewRequest(viewArn)
    def viewArn: GetViewInputViewArnString
    def getViewArn: ZIO[Any, Nothing, GetViewInputViewArnString] =
      ZIO.succeed(viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest
  ) extends zio.aws.resourceexplorer2.model.GetViewRequest.ReadOnly {
    override val viewArn: GetViewInputViewArnString =
      zio.aws.resourceexplorer2.model.primitives
        .GetViewInputViewArnString(impl.viewArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest
  ): zio.aws.resourceexplorer2.model.GetViewRequest.ReadOnly = new Wrapper(impl)
}
