package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDefaultViewResponse(
    viewArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewResponse = {
    import GetDefaultViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewResponse
      .builder()
      .optionallyWith(viewArn.map(value => value: java.lang.String))(_.viewArn)
      .build()
  }
  def asReadOnly
      : zio.aws.resourceexplorer2.model.GetDefaultViewResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.GetDefaultViewResponse.wrap(buildAwsValue())
}
object GetDefaultViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.GetDefaultViewResponse =
      zio.aws.resourceexplorer2.model
        .GetDefaultViewResponse(viewArn.map(value => value))
    def viewArn: Optional[String]
    def getViewArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("viewArn", viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewResponse
  ) extends zio.aws.resourceexplorer2.model.GetDefaultViewResponse.ReadOnly {
    override val viewArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.viewArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewResponse
  ): zio.aws.resourceexplorer2.model.GetDefaultViewResponse.ReadOnly =
    new Wrapper(impl)
}
