package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.resourceexplorer2.model.primitives.DeleteViewInputViewArnString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteViewRequest(viewArn: DeleteViewInputViewArnString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest = {
    import DeleteViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest
      .builder()
      .viewArn(DeleteViewInputViewArnString.unwrap(viewArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.DeleteViewRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.DeleteViewRequest.wrap(buildAwsValue())
}
object DeleteViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.DeleteViewRequest =
      zio.aws.resourceexplorer2.model.DeleteViewRequest(viewArn)
    def viewArn: DeleteViewInputViewArnString
    def getViewArn: ZIO[Any, Nothing, DeleteViewInputViewArnString] =
      ZIO.succeed(viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest
  ) extends zio.aws.resourceexplorer2.model.DeleteViewRequest.ReadOnly {
    override val viewArn: DeleteViewInputViewArnString =
      zio.aws.resourceexplorer2.model.primitives
        .DeleteViewInputViewArnString(impl.viewArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest
  ): zio.aws.resourceexplorer2.model.DeleteViewRequest.ReadOnly = new Wrapper(
    impl
  )
}
