package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.resourceexplorer2.model.primitives.SearchFilterFilterStringString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SearchFilter(filterString: SearchFilterFilterStringString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.SearchFilter = {
    import SearchFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.SearchFilter
      .builder()
      .filterString(
        SearchFilterFilterStringString.unwrap(filterString): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly =
    zio.aws.resourceexplorer2.model.SearchFilter.wrap(buildAwsValue())
}
object SearchFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.SearchFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.SearchFilter =
      zio.aws.resourceexplorer2.model.SearchFilter(filterString)
    def filterString: SearchFilterFilterStringString
    def getFilterString: ZIO[Any, Nothing, SearchFilterFilterStringString] =
      ZIO.succeed(filterString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.SearchFilter
  ) extends zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly {
    override val filterString: SearchFilterFilterStringString =
      zio.aws.resourceexplorer2.model.primitives
        .SearchFilterFilterStringString(impl.filterString())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.SearchFilter
  ): zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly = new Wrapper(impl)
}
