package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSupportedResourceTypesResponse(
    nextToken: Optional[String] = Optional.Absent,
    resourceTypes: Optional[
      Iterable[zio.aws.resourceexplorer2.model.SupportedResourceType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse = {
    import ListSupportedResourceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse
      .wrap(buildAwsValue())
}
object ListSupportedResourceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse =
      zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse(
        nextToken.map(value => value),
        resourceTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def resourceTypes: Optional[
      List[zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceTypes: ZIO[Any, AwsError, List[
      zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse
  ) extends zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val resourceTypes: Optional[
      List[zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourceexplorer2.model.SupportedResourceType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse
  ): zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse.ReadOnly =
    new Wrapper(impl)
}
