package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteViewResponse(
    viewArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewResponse = {
    import DeleteViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewResponse
      .builder()
      .optionallyWith(viewArn.map(value => value: java.lang.String))(_.viewArn)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.DeleteViewResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.DeleteViewResponse.wrap(buildAwsValue())
}
object DeleteViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.DeleteViewResponse =
      zio.aws.resourceexplorer2.model
        .DeleteViewResponse(viewArn.map(value => value))
    def viewArn: Optional[String]
    def getViewArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("viewArn", viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewResponse
  ) extends zio.aws.resourceexplorer2.model.DeleteViewResponse.ReadOnly {
    override val viewArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.viewArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewResponse
  ): zio.aws.resourceexplorer2.model.DeleteViewResponse.ReadOnly = new Wrapper(
    impl
  )
}
