package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateViewResponse(
    view: Optional[zio.aws.resourceexplorer2.model.View] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.CreateViewResponse = {
    import CreateViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.CreateViewResponse
      .builder()
      .optionallyWith(view.map(value => value.buildAwsValue()))(_.view)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.CreateViewResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.CreateViewResponse.wrap(buildAwsValue())
}
object CreateViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.CreateViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.CreateViewResponse =
      zio.aws.resourceexplorer2.model
        .CreateViewResponse(view.map(value => value.asEditable))
    def view: Optional[zio.aws.resourceexplorer2.model.View.ReadOnly]
    def getView
        : ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.View.ReadOnly] =
      AwsError.unwrapOptionField("view", view)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.CreateViewResponse
  ) extends zio.aws.resourceexplorer2.model.CreateViewResponse.ReadOnly {
    override val view: Optional[zio.aws.resourceexplorer2.model.View.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.view())
        .map(value => zio.aws.resourceexplorer2.model.View.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.CreateViewResponse
  ): zio.aws.resourceexplorer2.model.CreateViewResponse.ReadOnly = new Wrapper(
    impl
  )
}
