package zio.aws.resourceexplorer2
import zio.aws.resourceexplorer2.model.UpdateViewResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient
import zio.aws.resourceexplorer2.model.{
  UpdateViewRequest,
  DeleteViewRequest,
  CreateIndexRequest,
  GetViewRequest,
  ListTagsForResourceRequest,
  BatchGetViewRequest,
  SearchRequest,
  CreateViewRequest,
  AssociateDefaultViewRequest,
  UpdateIndexTypeRequest,
  UntagResourceRequest,
  ListSupportedResourceTypesRequest,
  ListIndexesRequest,
  DeleteIndexRequest,
  TagResourceRequest,
  ListViewsRequest
}
import zio.stream.ZStream
object ResourceExplorer2Mock extends Mock[ResourceExplorer2] {
  object DeleteView
      extends Effect[
        DeleteViewRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.DeleteViewResponse.ReadOnly
      ]
  object DisassociateDefaultView extends Effect[Unit, AwsError, Unit]
  object GetView
      extends Effect[
        GetViewRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.GetViewResponse.ReadOnly
      ]
  object ListIndexes
      extends Stream[
        ListIndexesRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.Index.ReadOnly
      ]
  object ListIndexesPaginated
      extends Effect[
        ListIndexesRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.ListIndexesResponse.ReadOnly
      ]
  object GetIndex
      extends Effect[
        Unit,
        AwsError,
        zio.aws.resourceexplorer2.model.GetIndexResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.UntagResourceResponse.ReadOnly
      ]
  object CreateView
      extends Effect[
        CreateViewRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.CreateViewResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetDefaultView
      extends Effect[
        Unit,
        AwsError,
        zio.aws.resourceexplorer2.model.GetDefaultViewResponse.ReadOnly
      ]
  object BatchGetView
      extends Effect[
        BatchGetViewRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.BatchGetViewResponse.ReadOnly
      ]
  object ListSupportedResourceTypes
      extends Stream[
        ListSupportedResourceTypesRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly
      ]
  object ListSupportedResourceTypesPaginated
      extends Effect[
        ListSupportedResourceTypesRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse.ReadOnly
      ]
  object AssociateDefaultView
      extends Effect[
        AssociateDefaultViewRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.AssociateDefaultViewResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.TagResourceResponse.ReadOnly
      ]
  object DeleteIndex
      extends Effect[
        DeleteIndexRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.DeleteIndexResponse.ReadOnly
      ]
  object Search
      extends Effect[SearchRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly,
        zio.aws.resourceexplorer2.model.Resource.ReadOnly
      ]]
  object SearchPaginated
      extends Effect[
        SearchRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly
      ]
  object ListViews extends Stream[ListViewsRequest, AwsError, String]
  object ListViewsPaginated
      extends Effect[
        ListViewsRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.ListViewsResponse.ReadOnly
      ]
  object UpdateIndexType
      extends Effect[
        UpdateIndexTypeRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse.ReadOnly
      ]
  object UpdateView extends Effect[UpdateViewRequest, AwsError, ReadOnly]
  object CreateIndex
      extends Effect[
        CreateIndexRequest,
        AwsError,
        zio.aws.resourceexplorer2.model.CreateIndexResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ResourceExplorer2] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ResourceExplorer2] { rts =>
        ZIO.succeed {
          new ResourceExplorer2 {
            val api: ResourceExplorer2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ResourceExplorer2 = this
            def deleteView(request: DeleteViewRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.DeleteViewResponse.ReadOnly
            ] = proxy(DeleteView, request)
            def disassociateDefaultView(): IO[AwsError, Unit] =
              proxy(DisassociateDefaultView)
            def getView(request: GetViewRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.GetViewResponse.ReadOnly
            ] = proxy(GetView, request)
            def listIndexes(request: ListIndexesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.resourceexplorer2.model.Index.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListIndexes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listIndexesPaginated(request: ListIndexesRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.ListIndexesResponse.ReadOnly
            ] = proxy(ListIndexesPaginated, request)
            def getIndex(): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.GetIndexResponse.ReadOnly
            ] = proxy(GetIndex)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createView(request: CreateViewRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.CreateViewResponse.ReadOnly
            ] = proxy(CreateView, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def getDefaultView(): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.GetDefaultViewResponse.ReadOnly
            ] = proxy(GetDefaultView)
            def batchGetView(request: BatchGetViewRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.BatchGetViewResponse.ReadOnly
            ] = proxy(BatchGetView, request)
            def listSupportedResourceTypes(
                request: ListSupportedResourceTypesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSupportedResourceTypes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSupportedResourceTypesPaginated(
                request: ListSupportedResourceTypesRequest
            ): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.ListSupportedResourceTypesResponse.ReadOnly
            ] = proxy(ListSupportedResourceTypesPaginated, request)
            def associateDefaultView(request: AssociateDefaultViewRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.AssociateDefaultViewResponse.ReadOnly
            ] = proxy(AssociateDefaultView, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def deleteIndex(request: DeleteIndexRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.DeleteIndexResponse.ReadOnly
            ] = proxy(DeleteIndex, request)
            def search(
                request: SearchRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly,
              zio.aws.resourceexplorer2.model.Resource.ReadOnly
            ]] = proxy(Search, request)
            def searchPaginated(request: SearchRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly
            ] = proxy(SearchPaginated, request)
            def listViews(
                request: ListViewsRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListViews, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listViewsPaginated(request: ListViewsRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.ListViewsResponse.ReadOnly
            ] = proxy(ListViewsPaginated, request)
            def updateIndexType(request: UpdateIndexTypeRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.UpdateIndexTypeResponse.ReadOnly
            ] = proxy(UpdateIndexType, request)
            def updateView(request: UpdateViewRequest): IO[AwsError, ReadOnly] =
              proxy(UpdateView, request)
            def createIndex(request: CreateIndexRequest): IO[
              AwsError,
              zio.aws.resourceexplorer2.model.CreateIndexResponse.ReadOnly
            ] = proxy(CreateIndex, request)
          }
        }
      }
    }
  }
}
