package zio.aws.resourceexplorer2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.{
  SearchInputViewArnString,
  QueryString,
  SearchInputNextTokenString,
  SearchInputMaxResultsInteger
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchRequest(
    maxResults: Optional[SearchInputMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[SearchInputNextTokenString] = Optional.Absent,
    queryString: QueryString,
    viewArn: Optional[SearchInputViewArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest = {
    import SearchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          SearchInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          SearchInputNextTokenString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        viewArn.map(value =>
          SearchInputViewArnString.unwrap(value): java.lang.String
        )
      )(_.viewArn)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.SearchRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.SearchRequest.wrap(buildAwsValue())
}
object SearchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.SearchRequest =
      zio.aws.resourceexplorer2.model.SearchRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        queryString,
        viewArn.map(value => value)
      )
    def maxResults: Optional[SearchInputMaxResultsInteger]
    def nextToken: Optional[SearchInputNextTokenString]
    def queryString: QueryString
    def viewArn: Optional[SearchInputViewArnString]
    def getMaxResults: ZIO[Any, AwsError, SearchInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, SearchInputNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getViewArn: ZIO[Any, AwsError, SearchInputViewArnString] =
      AwsError.unwrapOptionField("viewArn", viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest
  ) extends zio.aws.resourceexplorer2.model.SearchRequest.ReadOnly {
    override val maxResults: Optional[SearchInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SearchInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[SearchInputNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SearchInputNextTokenString(value)
        )
    override val queryString: QueryString =
      zio.aws.resourceexplorer2.model.primitives.QueryString(impl.queryString())
    override val viewArn: Optional[SearchInputViewArnString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewArn())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SearchInputViewArnString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest
  ): zio.aws.resourceexplorer2.model.SearchRequest.ReadOnly = new Wrapper(impl)
}
