package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.resourceexplorer2.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.resourceexplorer2.model.ListTagsForResourceResponse =
      zio.aws.resourceexplorer2.model
        .ListTagsForResourceResponse(tags.map(value => value))
    def tags: Optional[Map[String, String]]
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceResponse
  ) extends zio.aws.resourceexplorer2.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceResponse
  ): zio.aws.resourceexplorer2.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
