package zio.aws.resourceexplorer2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.{
  ListIndexesInputNextTokenString,
  ListIndexesInputMaxResultsInteger
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListIndexesRequest(
    maxResults: Optional[ListIndexesInputMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[ListIndexesInputNextTokenString] = Optional.Absent,
    regions: Optional[Iterable[String]] = Optional.Absent,
    `type`: Optional[zio.aws.resourceexplorer2.model.IndexType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest = {
    import ListIndexesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListIndexesInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          ListIndexesInputNextTokenString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.ListIndexesRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.ListIndexesRequest.wrap(buildAwsValue())
}
object ListIndexesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.ListIndexesRequest =
      zio.aws.resourceexplorer2.model.ListIndexesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        regions.map(value => value),
        `type`.map(value => value)
      )
    def maxResults: Optional[ListIndexesInputMaxResultsInteger]
    def nextToken: Optional[ListIndexesInputNextTokenString]
    def regions: Optional[List[String]]
    def `type`: Optional[zio.aws.resourceexplorer2.model.IndexType]
    def getMaxResults: ZIO[Any, AwsError, ListIndexesInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, ListIndexesInputNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("regions", regions)
    def getType: ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.IndexType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest
  ) extends zio.aws.resourceexplorer2.model.ListIndexesRequest.ReadOnly {
    override val maxResults: Optional[ListIndexesInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .ListIndexesInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[ListIndexesInputNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .ListIndexesInputNextTokenString(value)
        )
    override val regions: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val `type`: Optional[zio.aws.resourceexplorer2.model.IndexType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.resourceexplorer2.model.IndexType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest
  ): zio.aws.resourceexplorer2.model.ListIndexesRequest.ReadOnly = new Wrapper(
    impl
  )
}
