package zio.aws.resourceexplorer2.model
import scala.jdk.CollectionConverters.*
sealed trait IndexState {
  def unwrap: software.amazon.awssdk.services.resourceexplorer2.model.IndexState
}
object IndexState {
  def wrap(
      value: software.amazon.awssdk.services.resourceexplorer2.model.IndexState
  ): zio.aws.resourceexplorer2.model.IndexState = value match {
    case software.amazon.awssdk.services.resourceexplorer2.model.IndexState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.resourceexplorer2.model.IndexState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.resourceexplorer2.model.IndexState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.resourceexplorer2.model.IndexState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.resourceexplorer2.model.IndexState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.resourceexplorer2.model.IndexState.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.resourceexplorer2.model.IndexState {
    override def unwrap
        : software.amazon.awssdk.services.resourceexplorer2.model.IndexState =
      software.amazon.awssdk.services.resourceexplorer2.model.IndexState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.resourceexplorer2.model.IndexState {
    override def unwrap
        : software.amazon.awssdk.services.resourceexplorer2.model.IndexState =
      software.amazon.awssdk.services.resourceexplorer2.model.IndexState.CREATING
  }
  case object ACTIVE extends zio.aws.resourceexplorer2.model.IndexState {
    override def unwrap
        : software.amazon.awssdk.services.resourceexplorer2.model.IndexState =
      software.amazon.awssdk.services.resourceexplorer2.model.IndexState.ACTIVE
  }
  case object DELETING extends zio.aws.resourceexplorer2.model.IndexState {
    override def unwrap
        : software.amazon.awssdk.services.resourceexplorer2.model.IndexState =
      software.amazon.awssdk.services.resourceexplorer2.model.IndexState.DELETING
  }
  case object DELETED extends zio.aws.resourceexplorer2.model.IndexState {
    override def unwrap
        : software.amazon.awssdk.services.resourceexplorer2.model.IndexState =
      software.amazon.awssdk.services.resourceexplorer2.model.IndexState.DELETED
  }
  case object UPDATING extends zio.aws.resourceexplorer2.model.IndexState {
    override def unwrap
        : software.amazon.awssdk.services.resourceexplorer2.model.IndexState =
      software.amazon.awssdk.services.resourceexplorer2.model.IndexState.UPDATING
  }
}
