package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetViewError(errorMessage: String, viewArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError = {
    import BatchGetViewError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError
      .builder()
      .errorMessage(errorMessage: java.lang.String)
      .viewArn(viewArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.BatchGetViewError.ReadOnly =
    zio.aws.resourceexplorer2.model.BatchGetViewError.wrap(buildAwsValue())
}
object BatchGetViewError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.BatchGetViewError =
      zio.aws.resourceexplorer2.model.BatchGetViewError(errorMessage, viewArn)
    def errorMessage: String
    def viewArn: String
    def getErrorMessage: ZIO[Any, Nothing, String] = ZIO.succeed(errorMessage)
    def getViewArn: ZIO[Any, Nothing, String] = ZIO.succeed(viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError
  ) extends zio.aws.resourceexplorer2.model.BatchGetViewError.ReadOnly {
    override val errorMessage: String = impl.errorMessage(): String
    override val viewArn: String = impl.viewArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewError
  ): zio.aws.resourceexplorer2.model.BatchGetViewError.ReadOnly = new Wrapper(
    impl
  )
}
