package zio.aws.resourceexplorer2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class View(
    filters: Optional[zio.aws.resourceexplorer2.model.SearchFilter] =
      Optional.Absent,
    includedProperties: Optional[
      Iterable[zio.aws.resourceexplorer2.model.IncludedProperty]
    ] = Optional.Absent,
    lastUpdatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    owner: Optional[String] = Optional.Absent,
    scope: Optional[String] = Optional.Absent,
    viewArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.View = {
    import View.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.View
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        includedProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includedProperties)
      .optionallyWith(
        lastUpdatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.lastUpdatedAt)
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .optionallyWith(scope.map(value => value: java.lang.String))(_.scope)
      .optionallyWith(viewArn.map(value => value: java.lang.String))(_.viewArn)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.View.ReadOnly =
    zio.aws.resourceexplorer2.model.View.wrap(buildAwsValue())
}
object View {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.View
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.View =
      zio.aws.resourceexplorer2.model.View(
        filters.map(value => value.asEditable),
        includedProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastUpdatedAt.map(value => value),
        owner.map(value => value),
        scope.map(value => value),
        viewArn.map(value => value)
      )
    def filters: Optional[zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly]
    def includedProperties: Optional[
      List[zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly]
    ]
    def lastUpdatedAt: Optional[SyntheticTimestamp_date_time]
    def owner: Optional[String]
    def scope: Optional[String]
    def viewArn: Optional[String]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getIncludedProperties: ZIO[Any, AwsError, List[
      zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("includedProperties", includedProperties)
    def getLastUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("owner", owner)
    def getScope: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scope", scope)
    def getViewArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("viewArn", viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.View
  ) extends zio.aws.resourceexplorer2.model.View.ReadOnly {
    override val filters
        : Optional[zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.resourceexplorer2.model.SearchFilter.wrap(value))
    override val includedProperties: Optional[
      List[zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.includedProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourceexplorer2.model.IncludedProperty.wrap(item)
        }.toList
      )
    override val lastUpdatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedAt())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val owner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => value: String)
    override val scope: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scope())
      .map(value => value: String)
    override val viewArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.viewArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.View
  ): zio.aws.resourceexplorer2.model.View.ReadOnly = new Wrapper(impl)
}
