package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SupportedResourceType(
    resourceType: Optional[String] = Optional.Absent,
    service: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType = {
    import SupportedResourceType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType
      .builder()
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(service.map(value => value: java.lang.String))(_.service)
      .build()
  }
  def asReadOnly
      : zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly =
    zio.aws.resourceexplorer2.model.SupportedResourceType.wrap(buildAwsValue())
}
object SupportedResourceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.SupportedResourceType =
      zio.aws.resourceexplorer2.model.SupportedResourceType(
        resourceType.map(value => value),
        service.map(value => value)
      )
    def resourceType: Optional[String]
    def service: Optional[String]
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getService: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType
  ) extends zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly {
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val service: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.service())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType
  ): zio.aws.resourceexplorer2.model.SupportedResourceType.ReadOnly =
    new Wrapper(impl)
}
