package zio.aws.resourceexplorer2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Resource(
    arn: Optional[String] = Optional.Absent,
    lastReportedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    owningAccountId: Optional[String] = Optional.Absent,
    properties: Optional[
      Iterable[zio.aws.resourceexplorer2.model.ResourceProperty]
    ] = Optional.Absent,
    region: Optional[String] = Optional.Absent,
    resourceType: Optional[String] = Optional.Absent,
    service: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.Resource
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        lastReportedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.lastReportedAt)
      .optionallyWith(owningAccountId.map(value => value: java.lang.String))(
        _.owningAccountId
      )
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(service.map(value => value: java.lang.String))(_.service)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.Resource.ReadOnly =
    zio.aws.resourceexplorer2.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.Resource =
      zio.aws.resourceexplorer2.model.Resource(
        arn.map(value => value),
        lastReportedAt.map(value => value),
        owningAccountId.map(value => value),
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        region.map(value => value),
        resourceType.map(value => value),
        service.map(value => value)
      )
    def arn: Optional[String]
    def lastReportedAt: Optional[SyntheticTimestamp_date_time]
    def owningAccountId: Optional[String]
    def properties: Optional[
      List[zio.aws.resourceexplorer2.model.ResourceProperty.ReadOnly]
    ]
    def region: Optional[String]
    def resourceType: Optional[String]
    def service: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getLastReportedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("lastReportedAt", lastReportedAt)
    def getOwningAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("owningAccountId", owningAccountId)
    def getProperties: ZIO[Any, AwsError, List[
      zio.aws.resourceexplorer2.model.ResourceProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getService: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.Resource
  ) extends zio.aws.resourceexplorer2.model.Resource.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val lastReportedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastReportedAt())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val owningAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.owningAccountId())
      .map(value => value: String)
    override val properties: Optional[
      List[zio.aws.resourceexplorer2.model.ResourceProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourceexplorer2.model.ResourceProperty.wrap(item)
        }.toList
      )
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val service: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.service())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.Resource
  ): zio.aws.resourceexplorer2.model.Resource.ReadOnly = new Wrapper(impl)
}
