package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListIndexesResponse(
    indexes: Optional[Iterable[zio.aws.resourceexplorer2.model.Index]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse = {
    import ListIndexesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse
      .builder()
      .optionallyWith(
        indexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.indexes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.ListIndexesResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.ListIndexesResponse.wrap(buildAwsValue())
}
object ListIndexesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.ListIndexesResponse =
      zio.aws.resourceexplorer2.model.ListIndexesResponse(
        indexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def indexes: Optional[List[zio.aws.resourceexplorer2.model.Index.ReadOnly]]
    def nextToken: Optional[String]
    def getIndexes: ZIO[Any, AwsError, List[
      zio.aws.resourceexplorer2.model.Index.ReadOnly
    ]] = AwsError.unwrapOptionField("indexes", indexes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse
  ) extends zio.aws.resourceexplorer2.model.ListIndexesResponse.ReadOnly {
    override val indexes
        : Optional[List[zio.aws.resourceexplorer2.model.Index.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourceexplorer2.model.Index.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse
  ): zio.aws.resourceexplorer2.model.ListIndexesResponse.ReadOnly = new Wrapper(
    impl
  )
}
