package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Index(
    arn: Optional[String] = Optional.Absent,
    region: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.resourceexplorer2.model.IndexType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.Index = {
    import Index.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.Index
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.Index.ReadOnly =
    zio.aws.resourceexplorer2.model.Index.wrap(buildAwsValue())
}
object Index {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.Index
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.Index =
      zio.aws.resourceexplorer2.model.Index(
        arn.map(value => value),
        region.map(value => value),
        `type`.map(value => value)
      )
    def arn: Optional[String]
    def region: Optional[String]
    def `type`: Optional[zio.aws.resourceexplorer2.model.IndexType]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getType: ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.IndexType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.Index
  ) extends zio.aws.resourceexplorer2.model.Index.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
    override val `type`: Optional[zio.aws.resourceexplorer2.model.IndexType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.resourceexplorer2.model.IndexType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.Index
  ): zio.aws.resourceexplorer2.model.Index.ReadOnly = new Wrapper(impl)
}
