package zio.aws.resourceexplorer2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetIndexResponse(
    arn: Optional[String] = Optional.Absent,
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    lastUpdatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    replicatingFrom: Optional[Iterable[String]] = Optional.Absent,
    replicatingTo: Optional[Iterable[String]] = Optional.Absent,
    state: Optional[zio.aws.resourceexplorer2.model.IndexState] =
      Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: Optional[zio.aws.resourceexplorer2.model.IndexType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.GetIndexResponse = {
    import GetIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.GetIndexResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .optionallyWith(
        lastUpdatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.lastUpdatedAt)
      .optionallyWith(
        replicatingFrom.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicatingFrom)
      .optionallyWith(
        replicatingTo.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicatingTo)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.GetIndexResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.GetIndexResponse.wrap(buildAwsValue())
}
object GetIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.GetIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.GetIndexResponse =
      zio.aws.resourceexplorer2.model.GetIndexResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        replicatingFrom.map(value => value),
        replicatingTo.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        `type`.map(value => value)
      )
    def arn: Optional[String]
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def lastUpdatedAt: Optional[SyntheticTimestamp_date_time]
    def replicatingFrom: Optional[List[String]]
    def replicatingTo: Optional[List[String]]
    def state: Optional[zio.aws.resourceexplorer2.model.IndexState]
    def tags: Optional[Map[String, String]]
    def `type`: Optional[zio.aws.resourceexplorer2.model.IndexType]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getReplicatingFrom: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicatingFrom", replicatingFrom)
    def getReplicatingTo: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicatingTo", replicatingTo)
    def getState
        : ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.IndexState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.IndexType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.GetIndexResponse
  ) extends zio.aws.resourceexplorer2.model.GetIndexResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val lastUpdatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedAt())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val replicatingFrom: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatingFrom())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val replicatingTo: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.replicatingTo())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val state: Optional[zio.aws.resourceexplorer2.model.IndexState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.resourceexplorer2.model.IndexState.wrap(value))
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`: Optional[zio.aws.resourceexplorer2.model.IndexType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.resourceexplorer2.model.IndexType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.GetIndexResponse
  ): zio.aws.resourceexplorer2.model.GetIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
