package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.resourceexplorer2.model.primitives.{
  ViewName,
  CreateViewInputClientTokenString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateViewRequest(
    clientToken: Optional[CreateViewInputClientTokenString] = Optional.Absent,
    filters: Optional[zio.aws.resourceexplorer2.model.SearchFilter] =
      Optional.Absent,
    includedProperties: Optional[
      Iterable[zio.aws.resourceexplorer2.model.IncludedProperty]
    ] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent,
    viewName: ViewName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest = {
    import CreateViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          CreateViewInputClientTokenString.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        includedProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includedProperties)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .viewName(ViewName.unwrap(viewName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.CreateViewRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.CreateViewRequest.wrap(buildAwsValue())
}
object CreateViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.CreateViewRequest =
      zio.aws.resourceexplorer2.model.CreateViewRequest(
        clientToken.map(value => value),
        filters.map(value => value.asEditable),
        includedProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        viewName
      )
    def clientToken: Optional[CreateViewInputClientTokenString]
    def filters: Optional[zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly]
    def includedProperties: Optional[
      List[zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly]
    ]
    def tags: Optional[Map[String, String]]
    def viewName: ViewName
    def getClientToken: ZIO[Any, AwsError, CreateViewInputClientTokenString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getIncludedProperties: ZIO[Any, AwsError, List[
      zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("includedProperties", includedProperties)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getViewName: ZIO[Any, Nothing, ViewName] = ZIO.succeed(viewName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest
  ) extends zio.aws.resourceexplorer2.model.CreateViewRequest.ReadOnly {
    override val clientToken: Optional[CreateViewInputClientTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .CreateViewInputClientTokenString(value)
        )
    override val filters
        : Optional[zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.resourceexplorer2.model.SearchFilter.wrap(value))
    override val includedProperties: Optional[
      List[zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.includedProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourceexplorer2.model.IncludedProperty.wrap(item)
        }.toList
      )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val viewName: ViewName =
      zio.aws.resourceexplorer2.model.primitives.ViewName(impl.viewName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest
  ): zio.aws.resourceexplorer2.model.CreateViewRequest.ReadOnly = new Wrapper(
    impl
  )
}
