package zio.aws.resourceexplorer2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateIndexResponse(
    arn: Optional[String] = Optional.Absent,
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    state: Optional[zio.aws.resourceexplorer2.model.IndexState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexResponse = {
    import CreateIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.CreateIndexResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.CreateIndexResponse.wrap(buildAwsValue())
}
object CreateIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.CreateIndexResponse =
      zio.aws.resourceexplorer2.model.CreateIndexResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        state.map(value => value)
      )
    def arn: Optional[String]
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def state: Optional[zio.aws.resourceexplorer2.model.IndexState]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState
        : ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.IndexState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexResponse
  ) extends zio.aws.resourceexplorer2.model.CreateIndexResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val state: Optional[zio.aws.resourceexplorer2.model.IndexState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.resourceexplorer2.model.IndexState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexResponse
  ): zio.aws.resourceexplorer2.model.CreateIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
