package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.resourceexplorer2.model.primitives.AssociateDefaultViewInputViewArnString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateDefaultViewRequest(
    viewArn: AssociateDefaultViewInputViewArnString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest = {
    import AssociateDefaultViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest
      .builder()
      .viewArn(
        AssociateDefaultViewInputViewArnString.unwrap(viewArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.resourceexplorer2.model.AssociateDefaultViewRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.AssociateDefaultViewRequest
      .wrap(buildAwsValue())
}
object AssociateDefaultViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.resourceexplorer2.model.AssociateDefaultViewRequest =
      zio.aws.resourceexplorer2.model.AssociateDefaultViewRequest(viewArn)
    def viewArn: AssociateDefaultViewInputViewArnString
    def getViewArn: ZIO[Any, Nothing, AssociateDefaultViewInputViewArnString] =
      ZIO.succeed(viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest
  ) extends zio.aws.resourceexplorer2.model.AssociateDefaultViewRequest.ReadOnly {
    override val viewArn: AssociateDefaultViewInputViewArnString =
      zio.aws.resourceexplorer2.model.primitives
        .AssociateDefaultViewInputViewArnString(impl.viewArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest
  ): zio.aws.resourceexplorer2.model.AssociateDefaultViewRequest.ReadOnly =
    new Wrapper(impl)
}
