package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateViewResponse(
    view: Optional[zio.aws.resourceexplorer2.model.View] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewResponse = {
    import UpdateViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewResponse
      .builder()
      .optionallyWith(view.map(value => value.buildAwsValue()))(_.view)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.UpdateViewResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.UpdateViewResponse.wrap(buildAwsValue())
}
object UpdateViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.UpdateViewResponse =
      zio.aws.resourceexplorer2.model
        .UpdateViewResponse(view.map(value => value.asEditable))
    def view: Optional[zio.aws.resourceexplorer2.model.View.ReadOnly]
    def getView
        : ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.View.ReadOnly] =
      AwsError.unwrapOptionField("view", view)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewResponse
  ) extends zio.aws.resourceexplorer2.model.UpdateViewResponse.ReadOnly {
    override val view: Optional[zio.aws.resourceexplorer2.model.View.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.view())
        .map(value => zio.aws.resourceexplorer2.model.View.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewResponse
  ): zio.aws.resourceexplorer2.model.UpdateViewResponse.ReadOnly = new Wrapper(
    impl
  )
}
