package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceCount(
    complete: Optional[Boolean] = Optional.Absent,
    totalResources: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.ResourceCount = {
    import ResourceCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.ResourceCount
      .builder()
      .optionallyWith(complete.map(value => value: java.lang.Boolean))(
        _.complete
      )
      .optionallyWith(totalResources.map(value => value: java.lang.Long))(
        _.totalResources
      )
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.ResourceCount.ReadOnly =
    zio.aws.resourceexplorer2.model.ResourceCount.wrap(buildAwsValue())
}
object ResourceCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.ResourceCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.ResourceCount =
      zio.aws.resourceexplorer2.model.ResourceCount(
        complete.map(value => value),
        totalResources.map(value => value)
      )
    def complete: Optional[Boolean]
    def totalResources: Optional[Long]
    def getComplete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("complete", complete)
    def getTotalResources: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalResources", totalResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ResourceCount
  ) extends zio.aws.resourceexplorer2.model.ResourceCount.ReadOnly {
    override val complete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.complete())
      .map(value => value: Boolean)
    override val totalResources: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalResources())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ResourceCount
  ): zio.aws.resourceexplorer2.model.ResourceCount.ReadOnly = new Wrapper(impl)
}
