package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListViewsResponse(
    nextToken: Optional[String] = Optional.Absent,
    views: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse = {
    import ListViewsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        views.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.views)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.ListViewsResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.ListViewsResponse.wrap(buildAwsValue())
}
object ListViewsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.ListViewsResponse =
      zio.aws.resourceexplorer2.model.ListViewsResponse(
        nextToken.map(value => value),
        views.map(value => value)
      )
    def nextToken: Optional[String]
    def views: Optional[List[String]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getViews: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("views", views)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse
  ) extends zio.aws.resourceexplorer2.model.ListViewsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val views: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.views())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse
  ): zio.aws.resourceexplorer2.model.ListViewsResponse.ReadOnly = new Wrapper(
    impl
  )
}
