package zio.aws.resourceexplorer2.model
import scala.jdk.CollectionConverters.*
sealed trait IndexType {
  def unwrap: software.amazon.awssdk.services.resourceexplorer2.model.IndexType
}
object IndexType {
  def wrap(
      value: software.amazon.awssdk.services.resourceexplorer2.model.IndexType
  ): zio.aws.resourceexplorer2.model.IndexType = value match {
    case software.amazon.awssdk.services.resourceexplorer2.model.IndexType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.resourceexplorer2.model.IndexType.LOCAL =>
      val r = LOCAL
      r
    case software.amazon.awssdk.services.resourceexplorer2.model.IndexType.AGGREGATOR =>
      val r = AGGREGATOR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.resourceexplorer2.model.IndexType {
    override def unwrap
        : software.amazon.awssdk.services.resourceexplorer2.model.IndexType =
      software.amazon.awssdk.services.resourceexplorer2.model.IndexType.UNKNOWN_TO_SDK_VERSION
  }
  case object LOCAL extends zio.aws.resourceexplorer2.model.IndexType {
    override def unwrap
        : software.amazon.awssdk.services.resourceexplorer2.model.IndexType =
      software.amazon.awssdk.services.resourceexplorer2.model.IndexType.LOCAL
  }
  case object AGGREGATOR extends zio.aws.resourceexplorer2.model.IndexType {
    override def unwrap
        : software.amazon.awssdk.services.resourceexplorer2.model.IndexType =
      software.amazon.awssdk.services.resourceexplorer2.model.IndexType.AGGREGATOR
  }
}
