package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetViewResponse(
    tags: Optional[Map[String, String]] = Optional.Absent,
    view: Optional[zio.aws.resourceexplorer2.model.View] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.GetViewResponse = {
    import GetViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.GetViewResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(view.map(value => value.buildAwsValue()))(_.view)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.GetViewResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.GetViewResponse.wrap(buildAwsValue())
}
object GetViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.GetViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.GetViewResponse =
      zio.aws.resourceexplorer2.model.GetViewResponse(
        tags.map(value => value),
        view.map(value => value.asEditable)
      )
    def tags: Optional[Map[String, String]]
    def view: Optional[zio.aws.resourceexplorer2.model.View.ReadOnly]
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getView
        : ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.View.ReadOnly] =
      AwsError.unwrapOptionField("view", view)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.GetViewResponse
  ) extends zio.aws.resourceexplorer2.model.GetViewResponse.ReadOnly {
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val view: Optional[zio.aws.resourceexplorer2.model.View.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.view())
        .map(value => zio.aws.resourceexplorer2.model.View.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.GetViewResponse
  ): zio.aws.resourceexplorer2.model.GetViewResponse.ReadOnly = new Wrapper(
    impl
  )
}
