package zio.aws.resourceexplorer2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeleteIndexResponse(
    arn: Optional[String] = Optional.Absent,
    lastUpdatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    state: Optional[zio.aws.resourceexplorer2.model.IndexState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexResponse = {
    import DeleteIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        lastUpdatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.lastUpdatedAt)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.DeleteIndexResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.DeleteIndexResponse.wrap(buildAwsValue())
}
object DeleteIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.DeleteIndexResponse =
      zio.aws.resourceexplorer2.model.DeleteIndexResponse(
        arn.map(value => value),
        lastUpdatedAt.map(value => value),
        state.map(value => value)
      )
    def arn: Optional[String]
    def lastUpdatedAt: Optional[SyntheticTimestamp_date_time]
    def state: Optional[zio.aws.resourceexplorer2.model.IndexState]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getLastUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getState
        : ZIO[Any, AwsError, zio.aws.resourceexplorer2.model.IndexState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexResponse
  ) extends zio.aws.resourceexplorer2.model.DeleteIndexResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val lastUpdatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedAt())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val state: Optional[zio.aws.resourceexplorer2.model.IndexState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.resourceexplorer2.model.IndexState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexResponse
  ): zio.aws.resourceexplorer2.model.DeleteIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
