package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    tags: Optional[Map[String, String]] = Optional.Absent,
    resourceArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .resourceArn(resourceArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.TagResourceRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.TagResourceRequest =
      zio.aws.resourceexplorer2.model
        .TagResourceRequest(tags.map(value => value), resourceArn)
    def tags: Optional[Map[String, String]]
    def resourceArn: String
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest
  ) extends zio.aws.resourceexplorer2.model.TagResourceRequest.ReadOnly {
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val resourceArn: String = impl.resourceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest
  ): zio.aws.resourceexplorer2.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
