package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.resourceexplorer2.model.primitives.{
  SearchOutputViewArnString,
  SearchOutputNextTokenString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchResponse(
    count: Optional[zio.aws.resourceexplorer2.model.ResourceCount] =
      Optional.Absent,
    nextToken: Optional[SearchOutputNextTokenString] = Optional.Absent,
    resources: Optional[Iterable[zio.aws.resourceexplorer2.model.Resource]] =
      Optional.Absent,
    viewArn: Optional[SearchOutputViewArnString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse = {
    import SearchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse
      .builder()
      .optionallyWith(count.map(value => value.buildAwsValue()))(_.count)
      .optionallyWith(
        nextToken.map(value =>
          SearchOutputNextTokenString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        viewArn.map(value =>
          SearchOutputViewArnString.unwrap(value): java.lang.String
        )
      )(_.viewArn)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.SearchResponse.wrap(buildAwsValue())
}
object SearchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.SearchResponse =
      zio.aws.resourceexplorer2.model.SearchResponse(
        count.map(value => value.asEditable),
        nextToken.map(value => value),
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        viewArn.map(value => value)
      )
    def count: Optional[zio.aws.resourceexplorer2.model.ResourceCount.ReadOnly]
    def nextToken: Optional[SearchOutputNextTokenString]
    def resources
        : Optional[List[zio.aws.resourceexplorer2.model.Resource.ReadOnly]]
    def viewArn: Optional[SearchOutputViewArnString]
    def getCount: ZIO[
      Any,
      AwsError,
      zio.aws.resourceexplorer2.model.ResourceCount.ReadOnly
    ] = AwsError.unwrapOptionField("count", count)
    def getNextToken: ZIO[Any, AwsError, SearchOutputNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.resourceexplorer2.model.Resource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
    def getViewArn: ZIO[Any, AwsError, SearchOutputViewArnString] =
      AwsError.unwrapOptionField("viewArn", viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse
  ) extends zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly {
    override val count
        : Optional[zio.aws.resourceexplorer2.model.ResourceCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.count())
        .map(value => zio.aws.resourceexplorer2.model.ResourceCount.wrap(value))
    override val nextToken: Optional[SearchOutputNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SearchOutputNextTokenString(value)
        )
    override val resources
        : Optional[List[zio.aws.resourceexplorer2.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourceexplorer2.model.Resource.wrap(item)
          }.toList
        )
    override val viewArn: Optional[SearchOutputViewArnString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewArn())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SearchOutputViewArnString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse
  ): zio.aws.resourceexplorer2.model.SearchResponse.ReadOnly = new Wrapper(impl)
}
