package zio.aws.resourceexplorer2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourceexplorer2.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ResourceProperty(
    data: Optional[zio.aws.resourceexplorer2.model.Document] = Optional.Absent,
    lastReportedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.ResourceProperty = {
    import ResourceProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.ResourceProperty
      .builder()
      .optionallyWith(data.map(value => value))(_.data)
      .optionallyWith(
        lastReportedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.lastReportedAt)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.ResourceProperty.ReadOnly =
    zio.aws.resourceexplorer2.model.ResourceProperty.wrap(buildAwsValue())
}
object ResourceProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.ResourceProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.ResourceProperty =
      zio.aws.resourceexplorer2.model.ResourceProperty(
        data.map(value => value),
        lastReportedAt.map(value => value),
        name.map(value => value)
      )
    def data: Optional[software.amazon.awssdk.core.document.Document]
    def lastReportedAt: Optional[SyntheticTimestamp_date_time]
    def name: Optional[String]
    def getData
        : ZIO[Any, AwsError, software.amazon.awssdk.core.document.Document] =
      AwsError.unwrapOptionField("data", data)
    def getLastReportedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("lastReportedAt", lastReportedAt)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ResourceProperty
  ) extends zio.aws.resourceexplorer2.model.ResourceProperty.ReadOnly {
    override val data: Optional[software.amazon.awssdk.core.document.Document] =
      zio.aws.core.internal.optionalFromNullable(impl.data())
    override val lastReportedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastReportedAt())
        .map(value =>
          zio.aws.resourceexplorer2.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.ResourceProperty
  ): zio.aws.resourceexplorer2.model.ResourceProperty.ReadOnly = new Wrapper(
    impl
  )
}
