package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetViewRequest(
    viewArns: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest = {
    import BatchGetViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest
      .builder()
      .optionallyWith(
        viewArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.viewArns)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.BatchGetViewRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.BatchGetViewRequest.wrap(buildAwsValue())
}
object BatchGetViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.BatchGetViewRequest =
      zio.aws.resourceexplorer2.model
        .BatchGetViewRequest(viewArns.map(value => value))
    def viewArns: Optional[List[String]]
    def getViewArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("viewArns", viewArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest
  ) extends zio.aws.resourceexplorer2.model.BatchGetViewRequest.ReadOnly {
    override val viewArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.viewArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest
  ): zio.aws.resourceexplorer2.model.BatchGetViewRequest.ReadOnly = new Wrapper(
    impl
  )
}
