package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.resourceexplorer2.model.primitives.UpdateViewInputViewArnString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateViewRequest(
    filters: Optional[zio.aws.resourceexplorer2.model.SearchFilter] =
      Optional.Absent,
    includedProperties: Optional[
      Iterable[zio.aws.resourceexplorer2.model.IncludedProperty]
    ] = Optional.Absent,
    viewArn: UpdateViewInputViewArnString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest = {
    import UpdateViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        includedProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includedProperties)
      .viewArn(UpdateViewInputViewArnString.unwrap(viewArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.UpdateViewRequest.ReadOnly =
    zio.aws.resourceexplorer2.model.UpdateViewRequest.wrap(buildAwsValue())
}
object UpdateViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.UpdateViewRequest =
      zio.aws.resourceexplorer2.model.UpdateViewRequest(
        filters.map(value => value.asEditable),
        includedProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        viewArn
      )
    def filters: Optional[zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly]
    def includedProperties: Optional[
      List[zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly]
    ]
    def viewArn: UpdateViewInputViewArnString
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getIncludedProperties: ZIO[Any, AwsError, List[
      zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("includedProperties", includedProperties)
    def getViewArn: ZIO[Any, Nothing, UpdateViewInputViewArnString] =
      ZIO.succeed(viewArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest
  ) extends zio.aws.resourceexplorer2.model.UpdateViewRequest.ReadOnly {
    override val filters
        : Optional[zio.aws.resourceexplorer2.model.SearchFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value => zio.aws.resourceexplorer2.model.SearchFilter.wrap(value))
    override val includedProperties: Optional[
      List[zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.includedProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourceexplorer2.model.IncludedProperty.wrap(item)
        }.toList
      )
    override val viewArn: UpdateViewInputViewArnString =
      zio.aws.resourceexplorer2.model.primitives
        .UpdateViewInputViewArnString(impl.viewArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest
  ): zio.aws.resourceexplorer2.model.UpdateViewRequest.ReadOnly = new Wrapper(
    impl
  )
}
