package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.resourceexplorer2.model.primitives.IncludedPropertyNameString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IncludedProperty(name: IncludedPropertyNameString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty = {
    import IncludedProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty
      .builder()
      .name(IncludedPropertyNameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly =
    zio.aws.resourceexplorer2.model.IncludedProperty.wrap(buildAwsValue())
}
object IncludedProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.IncludedProperty =
      zio.aws.resourceexplorer2.model.IncludedProperty(name)
    def name: IncludedPropertyNameString
    def getName: ZIO[Any, Nothing, IncludedPropertyNameString] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty
  ) extends zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly {
    override val name: IncludedPropertyNameString =
      zio.aws.resourceexplorer2.model.primitives
        .IncludedPropertyNameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty
  ): zio.aws.resourceexplorer2.model.IncludedProperty.ReadOnly = new Wrapper(
    impl
  )
}
