package zio.aws.resourceexplorer2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetViewResponse(
    errors: Optional[
      Iterable[zio.aws.resourceexplorer2.model.BatchGetViewError]
    ] = Optional.Absent,
    views: Optional[Iterable[zio.aws.resourceexplorer2.model.View]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewResponse = {
    import BatchGetViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        views.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.views)
      .build()
  }
  def asReadOnly
      : zio.aws.resourceexplorer2.model.BatchGetViewResponse.ReadOnly =
    zio.aws.resourceexplorer2.model.BatchGetViewResponse.wrap(buildAwsValue())
}
object BatchGetViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourceexplorer2.model.BatchGetViewResponse =
      zio.aws.resourceexplorer2.model.BatchGetViewResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        views.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[
      List[zio.aws.resourceexplorer2.model.BatchGetViewError.ReadOnly]
    ]
    def views: Optional[List[zio.aws.resourceexplorer2.model.View.ReadOnly]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.resourceexplorer2.model.BatchGetViewError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getViews: ZIO[Any, AwsError, List[
      zio.aws.resourceexplorer2.model.View.ReadOnly
    ]] = AwsError.unwrapOptionField("views", views)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewResponse
  ) extends zio.aws.resourceexplorer2.model.BatchGetViewResponse.ReadOnly {
    override val errors: Optional[
      List[zio.aws.resourceexplorer2.model.BatchGetViewError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourceexplorer2.model.BatchGetViewError.wrap(item)
        }.toList
      )
    override val views
        : Optional[List[zio.aws.resourceexplorer2.model.View.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.views())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourceexplorer2.model.View.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewResponse
  ): zio.aws.resourceexplorer2.model.BatchGetViewResponse.ReadOnly =
    new Wrapper(impl)
}
